@extends('layouts.app')

@section('title', 'Doctor Dashboard')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-6">Doctor Dashboard</h1>

    <!-- Quick Actions -->
    <div class="mb-4 sm:mb-6 flex flex-wrap gap-2">
        <a href="{{ route('doctor.availability') }}" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-calendar-alt"></i> <span class="hidden sm:inline">Manage Availability</span><span class="sm:hidden">Availability</span>
        </a>
        <a href="{{ route('doctor.profile') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-user"></i> <span class="hidden sm:inline">My Profile</span><span class="sm:hidden">Profile</span>
        </a>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fas fa-calendar text-blue-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['appointments'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-yellow-100 rounded-full">
                    <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Pending Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['pending_appointments'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-green-100 rounded-full">
                    <i class="fas fa-prescription text-green-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Prescriptions</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['prescriptions'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications Section -->
    @if($notifications->count() > 0)
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-3 sm:mb-4 gap-2">
            <h2 class="text-lg sm:text-xl font-bold">Notifications</h2>
            <form method="POST" action="{{ route('doctor.notifications.mark-all-read') }}" class="inline">
                @csrf
                <button type="submit" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">Mark all as read</button>
            </form>
        </div>
        <div class="space-y-3">
            @foreach($notifications as $notification)
            <div class="border-l-4 border-blue-500 bg-blue-50 p-4 rounded">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <p class="font-semibold text-gray-800">{{ $notification->data['message'] ?? 'New notification' }}</p>
                        @if(isset($notification->data['appointment_id']))
                            <p class="text-sm text-gray-600 mt-1">
                                Patient: {{ $notification->data['patient_name'] ?? 'N/A' }} | 
                                Type: {{ $notification->data['consultation_type'] ?? 'N/A' }}
                            </p>
                            <div class="mt-2 flex flex-col sm:flex-row gap-2">
                                <a href="{{ route('doctor.appointments') }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">View Appointment</a>
                                @if(isset($notification->data['appointment_id']))
                                    <a href="{{ route('doctor.video-call', $notification->data['appointment_id']) }}" class="text-xs sm:text-sm text-green-600 hover:text-green-900">Join Video Call</a>
                                @endif
                            </div>
                        @endif
                        <p class="text-xs text-gray-500 mt-2">{{ $notification->created_at->diffForHumans() }}</p>
                    </div>
                    <form method="POST" action="{{ route('doctor.notifications.mark-read', $notification->id) }}" class="ml-4">
                        @csrf
                        <button type="submit" class="text-gray-400 hover:text-gray-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </form>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <div class="bg-white rounded-lg shadow p-4 sm:p-6">
        <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Recent Appointments</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Branch</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($recentAppointments as $appointment)
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm sm:text-base">{{ $appointment->patient->full_name }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                            <span class="text-sm">{{ $appointment->branch->name }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-xs sm:text-sm">{{ $appointment->appointment_date->format('M d, Y H:i') }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs rounded-full bg-{{ $appointment->status === 'completed' ? 'green' : 'yellow' }}-100 text-{{ $appointment->status === 'completed' ? 'green' : 'yellow' }}-800">
                                {{ ucfirst($appointment->status) }}
                            </span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            @if($appointment->status !== 'completed')
                                <a href="{{ route('prescriptions.create', $appointment->id) }}" class="text-blue-600 hover:text-blue-900 text-xs sm:text-sm">
                                    <span class="hidden sm:inline">Create Prescription</span><span class="sm:hidden">Create</span>
                                </a>
                            @else
                                <a href="{{ route('prescriptions.show', $appointment->prescription->id) }}" class="text-green-600 hover:text-green-900 text-xs sm:text-sm">
                                    <span class="hidden sm:inline">View Prescription</span><span class="sm:hidden">View</span>
                                </a>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

